#include <cstdio>
#include <iostream>
#include <vector>
#include <algorithm>
#include <cstring>
#include <string>
#include <cmath>
#include <map>
#include <set>
#include <climits>
#include <cassert>
#include <cctype>
using namespace std;

typedef long long ll;
typedef double dbl;
typedef long double ld;

#define mp make_pair
#define pb push_back
#define sz(x) (int)x.size()
#define all(x) x.begin(),x.end()
#define X first
#define Y second

const int maxn = 2000 * 100 + 10;

ll dist[maxn];
set <int> imp[maxn];
vector< pair<int, int> > g[maxn];
map <pair <int, int>, int > maproads;

set <int> peres (set <int>& s1, set <int>& s2) {
	set <int> s;
	set <int>::iterator p = s1.begin(), q = s2.begin();
	while ((p != s1.end()) && (q != s2.end())) {
		if (*p < *q)
			p++;
		else if(*p > *q)
			q++;
		else {
			s.insert(*p);
			p++;
			q++;
		}
	}
	return s;
}

int main() {
#ifdef _MBCS
	freopen("input.txt", "r", stdin);
	freopen("output.txt", "w", stdout);
#endif
	int n, m;
	scanf("%d%d", &n, &m);
	for (int i = 0; i < m; i++) {
		int a, b, w;
		scanf("%d%d%d", &a, &b, &w);
		a--, b--;
		g[a].pb(mp(b, w));
		g[b].pb(mp(a, w));
		maproads[mp(a, b)] = i;
		maproads[mp(b, a)] = i;
	}

	for (int i = 0; i < n; i++)
		dist[i] = INT_MAX;
	dist[0] = 0;

	set< pair<ll, int> > q;
	q.insert(mp(0, 0));
	while (!q.empty()) {
		pair<ll, int> top = *q.begin();
		q.erase(q.begin());
		for (int i = 0; i < sz(g[top.Y]); i++) {
			int next = g[top.Y][i].X;
			int w = g[top.Y][i].Y;
			if (dist[next] > dist[top.Y] + w) {
				q.erase(mp(dist[next], next));
				dist[next] = dist[top.Y] + w;

				set <int> &ss = imp[next];
				ss = imp[top.Y];
				ss.insert(maproads[mp(top.Y, next)]);

				q.insert(mp(dist[next], next));
			}
			else if (dist[next] == dist[top.Y] + w) {
				set <int> s = imp[top.Y];
				s.insert(maproads[mp(top.Y, next)]);
				imp[next] = peres(imp[next], s);
			}
		}
	}
	printf("%d\n", sz(imp[n - 1]));
	for (set <int>::iterator it = imp[n - 1].begin(); it != imp[n - 1].end(); it++) {
		printf("%d ", *it + 1);
	}
	return 0;
}